<?php $__env->startSection('title', translate('messages.subscriber_list')); ?>
<?php $__env->startPush('css_or_js'); ?>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <h1 class="page-header-title text-capitalize">
                <div class="card-header-icon d-inline-flex mr-2 img">
                    <img src="<?php echo e(dynamicAsset('/public/assets/admin/img/mail.png')); ?>" alt="public">
                </div>
                <span>
                    <?php echo e(translate('messages.subscribed_mail_list')); ?>

                </span>
            </h1>
        </div>
        <!-- End Page Header -->
        <!-- Card -->

        <div class="card mb-3">
            <div class="card-body">
                <form>
                    <div class="row g-3">
                        <div class="col-md-4">
                            <label class="form-label"><?php echo e(translate('Subscription Date')); ?></label>
                            <div class="position-relative">
                                <span class="tio-calendar icon-absolute-on-right"></span>
                                <input type="text" readonly name="join_date"
                                    value="<?php echo e(request()->get('join_date') ?? null); ?>"
                                    class="date-range-picker form-control">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label"><?php echo e(translate('Sort By')); ?></label>
                            <select name="filter" data-placeholder="<?php echo e(translate('messages.Select Mail Sorting Order')); ?>"
                                class="form-control js-select2-custom">
                                <option value="" selected disabled>
                                    <?php echo e(translate('messages.Select Mail Sorting Order')); ?> </option>
                                <option <?php echo e(request()->get('filter') == 'oldest' ? 'selected' : ''); ?> value="oldest">
                                    <?php echo e(translate('messages.Sort by oldest')); ?></option>
                                <option <?php echo e(request()->get('filter') == 'latest' ? 'selected' : ''); ?> value="latest">
                                    <?php echo e(translate('messages.Sort by newest')); ?></option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label"><?php echo e(translate('Choose First')); ?></label>
                            <input type="number" min="1" name="show_limit" class="form-control"
                                value="<?php echo e(request()->get('show_limit')); ?>" class="form-control"
                                placeholder="<?php echo e(translate('Ex : 100')); ?>">
                        </div>
                    </div>
                    <div class="btn--container justify-content-end mt-3">
                        <button type="submit" class="btn btn--primary"><?php echo e(translate('Filter')); ?></button>
                    </div>
                </form>
            </div>
        </div>



        <div class="card">
            <!-- Header -->
            <div class="card-header flex-wrap ">
                <h4><?php echo e(translate('messages.Mail List')); ?>

                    <span class="badge badge-soft-dark ml-2" id="count"><?php echo e($subscribers->count()); ?></span>
                </h4>
                <div class="search--button-wrapper border-0 justify-content-end">
                    <form class="search-form">
                        <div class="input-group input-group-flush input-group-merge input--group">
                            <input type="search" name="search" class="form-control"
                                placeholder="<?php echo e(translate('ex_: search_email')); ?>"
                                aria-label="<?php echo e(translate('messages.search')); ?>" value="<?php echo e(request()?->search); ?>">
                            <button type="submit" class="btn btn--secondary secondary-cmn"><i class="tio-search"></i></button>
                        </div>
                    </form>
                    <!-- Unfold -->
                    <div class="d-flex flex-wrap justify-content-sm-end align-items-sm-center ml-0 mr-0">
                        <div class="hs-unfold mr-2 ml-2">
                            <a class="js-hs-unfold-invoker btn btn-sm btn-white dropdown-toggle min-height-40"
                                href="javascript:;"
                                data-hs-unfold-options='{
                                    "target": "#usersExportDropdown",
                                    "type": "css-animation"
                                }'>
                                <i class="tio-download-to mr-1"></i> <?php echo e(translate('messages.export')); ?>

                            </a>

                            <div id="usersExportDropdown"
                                class="hs-unfold-content dropdown-unfold dropdown-menu dropdown-menu-sm-right">
                                <span class="dropdown-header"><?php echo e(translate('messages.download_options')); ?></span>
                                <a id="export-excel" class="dropdown-item"
                                    href="<?php echo e(route('admin.customer.subscriber-export', ['type' => 'excel', request()->getQueryString()])); ?>">
                                    <img class="avatar avatar-xss avatar-4by3 mr-2"
                                        src="<?php echo e(dynamicAsset('public/assets/admin')); ?>/svg/components/excel.svg"
                                        alt="Image Description">
                                    <?php echo e(translate('messages.excel')); ?>

                                </a>
                                <a id="export-csv" class="dropdown-item"
                                    href="<?php echo e(route('admin.customer.subscriber-export', ['type' => 'csv', request()->getQueryString()])); ?>">
                                    <img class="avatar avatar-xss avatar-4by3 mr-2"
                                        src="<?php echo e(dynamicAsset('public/assets/admin')); ?>/svg/components/placeholder-csv-format.svg"
                                        alt="Image Description">
                                    .<?php echo e(translate('messages.csv')); ?>

                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- End Unfold -->

            </div>
            <!-- End Header -->
            <!-- Table -->
            <div class="table-responsive datatable-custom">
                <table id="datatable"
                    class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table generalData"
                    data-hs-datatables-options='{
                                                             "columnDefs": [{
                                                                "targets": [0],
                                                                "orderable": false
                                                              }],
                                                             "order": [],
                                                             "info": {
                                                               "totalQty": "#datatableWithPaginationInfoTotalQty"
                                                             },
                                                             "search": "#datatableSearch",
                                                             "entries": "#datatableEntries",
                                                             "pageLength": 25,
                                                             "isResponsive": false,
                                                             "isShowPaging": false,
                                                             "paging":false
                                                           }'>
                    <thead class="thead-light">
                        <tr>
                            <th class="">
                                <?php echo e(translate('messages.sl')); ?>

                            </th>
                            <th><?php echo e(translate('messages.email')); ?></th>
                            <th><?php echo e(translate('messages.created_at')); ?></th>
                        </tr>
                    </thead>
                    <tbody id="set-rows">
                        <?php $__currentLoopData = $subscribers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <?php echo e($key + $subscribers->firstItem()); ?>

                                </td>
                                <td>
                                    <?php echo e($customer->email); ?>

                                </td>
                                <td>
                                    <?php echo e(\App\CentralLogics\Helpers::time_date_format($customer->created_at)); ?>

                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>

                </table>
                <?php if(count($subscribers) === 0): ?>
                    <div class="empty--data">
                        <img src="<?php echo e(dynamicAsset('/public/assets/admin/img/empty.png')); ?>" alt="public">
                        <h5>
                            <?php echo e(translate('no_data_found')); ?>

                        </h5>
                    </div>
                <?php endif; ?>
            </div>
            <!-- End Table -->
            <!-- Footer -->
            <div class="card-footer">
                <!-- Pagination -->
                <div class="row justify-content-center justify-content-sm-between align-items-sm-center">
                    <div class="col-sm-auto">
                        <div class="d-flex justify-content-center justify-content-sm-end">
                            <!-- Pagination -->
                            <?php echo $subscribers->withQueryString()->links(); ?>

                        </div>
                    </div>
                </div>
                <!-- End Pagination -->
            </div>
            <!-- End Footer -->
        </div>
        <!-- End Card -->
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script_2'); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\alab projects\Helo Idly\resources\views/admin-views/customer/subscriber/list.blade.php ENDPATH**/ ?>